﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Chapter6__Neapolitan_
{
    class Program
    {
        static int Infinity = 1000000;
        static int ccc = 0;

        #region Question 2,3
        struct KnaNode
        {
            public int level;
            public int profit;
            public int weight;
            public List<int> items;
        }
        static void knapsack2_withItems(int n, int[] p, int[] w, int W, ref int maxprofit, ref List<int> bestitems)
        {
            Queue<KnaNode> Q = new Queue<KnaNode>();
            KnaNode u = new KnaNode(), v = new KnaNode();
            v.items = new List<int>();
            Q.Enqueue(v);
            while (Q.Count > 0)
            {
                v = Q.Dequeue();
                u.level = v.level + 1;
                u.weight = v.weight + w[u.level];
                u.profit = v.profit + p[u.level];
                u.items = new List<int>(v.items); // copy v.items into u.items
                u.items.Add(u.level); // insert u.level into items
                if (u.weight <= W && u.profit > maxprofit)
                {
                    maxprofit = u.profit;
                    bestitems = new List<int>(u.items); // copy u.items into bestitems
                }
                if (bound(u, n, p, w, W) > maxprofit)
                    Q.Enqueue(u);
                u.weight = v.weight;
                u.profit = v.profit;
                u.items = new List<int>(v.items); // copy v.items into u.items
                if (bound(u, n, p, w, W) > maxprofit)
                    Q.Enqueue(u);
            }
        }
        static float bound(KnaNode u, int n, int[] p, int[] w, int W)
        {
            int j, k;
            int totweight;
            float result;
            if (u.weight >= W)
                return 0;
            else
            {
                result = u.profit;
                j = u.level + 1;
                totweight = u.weight;
                while (j <= n && totweight + w[j] <= W)
                {
                    totweight += w[j];
                    result += p[j];
                    j++;
                }
                k = j;
                if (k <= n)
                    result += ((W - totweight) * (float)p[k] / w[k]);
                return result;
            }
        }
        #endregion
        #region Question 9,11
        struct TSPNode
        {
            public int level;
            public int bound;
            public List<int> path;
        }
        class priority_queue_of_TSPnode
        {
            List<TSPNode> SList;
            public priority_queue_of_TSPnode()
            {
                SList = new List<TSPNode>();
            }
            public bool empty()
            {
                if (SList.Count > 0)
                    return false;
                else
                    return true;
            }
            public void insert(TSPNode node)
            {
                int index = 0;
                for (; index < SList.Count && SList[index].bound < node.bound; index++) ;
                SList.Insert(index, node);
            }
            public TSPNode remove()
            {
                TSPNode result = SList[0];
                SList.RemoveAt(0);
                return result;
            }
        }
        static void travel2(int n, int[,] W, ref List<int> opttour, ref int minlength)
        {
            priority_queue_of_TSPnode PQ = new priority_queue_of_TSPnode();
            TSPNode u = new TSPNode(), v = new TSPNode();
            v.level = 0;
            v.path = new List<int>();
            v.path.Add(1);
            v.bound = bound(v, W, n);
            minlength = Infinity;
            PQ.insert(v);
            while (!PQ.empty())
            {
                v = PQ.remove();
                if (v.bound < minlength)
                {
                    u.level = v.level + 1;
                    for (int i = 2; i <= n; i++)
                    {
                        if (!v.path.Contains(i))
                        {
                            u.path = new List<int>(v.path);
                            u.path.Add(i);
                            if (u.level == n - 1)
                            {
                                for (int j = 2; j <= n; j++)
                                {
                                    if (!u.path.Contains(j))
                                    {
                                        u.path.Add(j);      // add index of only vertex that not in u.path
                                        break;
                                    }
                                }
                                u.path.Add(1);
                                int len = length(u, W);
                                if (len < minlength)
                                {
                                    minlength = len;
                                    opttour = new List<int>(u.path);
                                }
                            }
                            else
                            {
                                u.bound = bound(u, W, n);
                                if (u.bound < minlength)
                                {
                                    PQ.insert(u);
                                }
                            }
                        }
                    }
                }
            }
        }
        static int length(TSPNode u, int[,] W)
        {
            int result = 0;
            for (int i = 1; i < u.path.Count; i++)
            {
                int FirstVertex = u.path[i - 1];
                int SecondVertex = u.path[i];
                result += W[FirstVertex, SecondVertex];
            }
            return result;
        }
        static int bound(TSPNode u, int[,] W, int n)
        {
            int result = 0;
            if (u.level > 0)
            {
                result += length(u, W);
            }
            int lastVertex = u.path[u.path.Count - 1];
            int minCost = Infinity;
            for (int i = 2; i <= n; i++)
            {
                if (!u.path.Contains(i) && W[lastVertex, i] < minCost)
                {
                    minCost = W[lastVertex, i];
                }
            }
            result += minCost;
            for (int i = 2; i <= n; i++)
            {
                if (!u.path.Contains(i))
                {
                    minCost = W[i, 1];
                    for (int j = 2; j <= n; j++)
                    {
                        if (!u.path.Contains(j) && i != j && W[i, j] < minCost)
                        {
                            minCost = W[i, j];
                        }
                    }
                    result += minCost;
                }
            }
            return result;
        }
        #endregion
        #region Question 12,15
        struct CooperNode
        {
            public int level;
            public float bound;
            public List<int> D;
        }
        class priority_queue_of_CooperNode
        {
            List<CooperNode> SList;
            public priority_queue_of_CooperNode()
            {
                SList = new List<CooperNode>();
            }
            public bool empty()
            {
                if (SList.Count > 0)
                    return false;
                else
                    return true;
            }
            public void insert(CooperNode node)
            {
                int index = 0;
                for (; index < SList.Count && SList[index].bound > node.bound; index++) ;
                SList.Insert(index, node);
            }
            public CooperNode remove()
            {
                CooperNode result = SList[0];
                SList.RemoveAt(0);
                return result;
            }
        }
        struct Description
        {
            public List<int> D;
            public float Probability;
        }
        class CooperDescribtions_SortedList
        {
            public List<Description> description;
            int capacity;
            public CooperDescribtions_SortedList(int cap)
            {
                description = new List<Description>(cap);
                capacity = cap;
            }
            public void insert(Description describe)
            {
                int index = 0;
                for (; index < description.Count && description[index].Probability > describe.Probability; index++) ;
                if (index < description.Capacity)
                    description.Insert(index, describe);
                if (description.Count > capacity) // remove additional results
                    description.RemoveRange(capacity, description.Count - capacity);
            }
            public int Count
            {
                get
                {
                    return description.Count;
                }
            }
            public float MinProb()
            {
                return description[Count - 1].Probability; // minimum probability of this sortedList
            }
        }
        static void cooper(int n, int m, out CooperDescribtions_SortedList mbest)
        {
            priority_queue_of_CooperNode PQ = new priority_queue_of_CooperNode();
            mbest = new CooperDescribtions_SortedList(m);  // initial mbest with m capacity
            Description describe;
            CooperNode u = new CooperNode(), v = new CooperNode();
            v.level = 0;
            v.D = new List<int>();
            describe.D = new List<int>();
            describe.Probability = ConditionalProb_withAssuming_S(v.D);
            mbest.insert(describe);
            v.bound = bound(v, n);
            PQ.insert(v);
            Print(v.D);
            Console.WriteLine("CondProb:"+ ConditionalProb_withAssuming_S(v.D) + " bound:" + v.bound);
            while (!PQ.empty())
            {
                v = PQ.remove();
                if (v.bound > mbest.MinProb())
                {
                    u.level = v.level + 1;
                    u.D = new List<int>(v.D);
                    u.D.Add(TTT(u.level));
                    if (ConditionalProb_withAssuming_S(u.D) > mbest.MinProb() || mbest.Count < m)
                    {
                        describe.D = new List<int>(u.D);
                        describe.Probability = ConditionalProb_withAssuming_S(u.D);
                        mbest.insert(describe);
                    }
                    u.bound = bound(u, n);
                    if (u.bound > mbest.MinProb())
                    {
                        PQ.insert(u);
                        Print(u.D);
                        Console.WriteLine("CondProb:" + ConditionalProb_withAssuming_S(u.D) + " bound:" + u.bound);
                    }
                    else
                    {
                        Print(u.D);
                        Console.WriteLine("CondProb:" + ConditionalProb_withAssuming_S(u.D) + " bound:" + u.bound);
                    }
                    u.D = new List<int>(v.D);
                    u.bound = bound(u, n);
                    if (u.bound > mbest.MinProb())
                    {
                        PQ.insert(u);
                        Print(u.D);
                        Console.WriteLine("CondProb:" + ConditionalProb_withAssuming_S(u.D) + " bound:" + u.bound);
                    }
                    else
                    {
                        Print(u.D);
                        Console.WriteLine("CondProb:" + ConditionalProb_withAssuming_S(u.D) + " bound:" + u.bound);
                    }
                }
            }
        }
        static float ConditionalProb_withAssuming_S(List<int> D)
        {
            if (D.Count == 0)
            {
                return 0.1f;
            }
            else if (D.Count == 1)
            {
                if (D[0] == 1)
                {
                    return 0.4f;
                }
                else if (D[0] == 2)
                {
                    return 0.15f;
                }
                else if (D[0] == 3)
                {
                    return 0.1f;
                }
                else if (D[0] == 4)
                {
                    return 0.6f;
                }
            }
            else if (D.Count == 2)
            {
                if (D.Contains(1) && D.Contains(2))
                {
                    return 0.1f;
                }
                else if (D.Contains(1) && D.Contains(3))
                {
                    return 0.05f;
                }
                else if (D.Contains(1) && D.Contains(4))
                {
                    return 0.65f;
                }
            }
            return 0;
        }
        static float Probability(List<int> D)
        {
            if (D.Count == 0)
            {
                return 0.9f;
            }
            else if (D.Count == 1)
            {
                if (D[0] == 1)
                {
                    return 0.009f;
                }
                else if (D[0] == 2)
                {
                    return 0.005f;
                }
                else if (D[0] == 3)
                {
                    return 0.002f;
                }
                else if (D[0] == 4)
                {
                    return 0.008f;
                }
            }
            else if (D.Count == 2)
            {
                if (D.Contains(1) && D.Contains(2))
                {
                    return 0.003f;
                }
                else if (D.Contains(1) && D.Contains(3))
                {
                    return 0.001f;
                }
                else if (D.Contains(1) && D.Contains(4))
                {
                    return 0.007f;
                }
            }
            return 0;
        }
        static float Probability_of_S()
        {
            return 0.01f;
        }
        static float bound(CooperNode u,int n)
        {
            if (u.level == n)
            {
                return 0;
            }
            else
            {
                return (Probability(u.D) / Probability_of_S());
            }
        }
        static int TTT(int ind)
        {
            if (ind == 1)
            {
                return 4;
            }
            else if (ind == 2)
            {
                return 1;
            }
            else if (ind == 3)
            {
                return 2;
            }
            else if (ind == 4)
            {
                return 3;
            }
            return 0;
        }
        #endregion

        static void Main(string[] args)
        {
            Console.WriteLine("\n-------------------------------------------------------------// 2,3");
            int[] w = new int[] { 0, 2, 5, 7, 3, 1 };
            int[] p = new int[] { 0, 20, 30, 35, 12, 3 };
            int n = w.Length - 1;
            int W = 13;
            int MaxProfit = 0;
            Kna_Sort(w, p, n);
            List<int> BestItems = new List<int>();
            knapsack2_withItems(n, p, w, W, ref MaxProfit, ref BestItems);
            Console.WriteLine("Max Profit : " + MaxProfit);
            Console.Write("Items : ");
            Print(BestItems);
            Console.WriteLine("\n-------------------------------------------------------------// 9,11");
            int I = Infinity;
            List<int> OptTour = new List<int>();
            int MinLength = I;
            //int[,] Weights = {                                    // Question 8
            //                 {  0,  0,  0,  0,  0,   0   },
            //                 {  0,  0,  6,  6,  10,  8   },
            //                 {  0,  3,  0,  12, 7,   6   },
            //                 {  0,  8,  7,  0,  14,  20  },
            //                 {  0,  5,  13, 9,  0,   8   },
            //                 {  0,  9,  8,  10, 6,   0   },
            //                 };
            int[,] Weights = {
                             {  0,  0,  0,  0,  0,  0,  0,  0,  0   },
                             {  0,  0,  5,  8,  I,  I,  I,  I,  I   },
                             {  0,  I,  0,  4,  I,  4,  I,  I,  I   },
                             {  0,  I,  I,  0,  2,  I,  I,  5,  I   },
                             {  0,  I,  I,  I,  0,  I,  I,  I,  7   },
                             {  0,  1,  I,  I,  I,  0,  I,  I,  I   },
                             {  0,  I,  6,  I,  I,  2,  0,  I,  I   },
                             {  0,  I,  I,  I,  3,  I,  8,  0,  I   },
                             {  0,  I,  I,  I,  I,  I,  5,  4,  0   }
                             };
            n = Weights.GetLength(0) - 1;
            travel2(n, Weights, ref OptTour, ref MinLength);
            Console.WriteLine("Min Length : " + MinLength);
            Console.Write("path : ");
            Print(OptTour);
            Console.WriteLine("\n-------------------------------------------------------------// 12,15");
            CooperDescribtions_SortedList mbest;
            cooper(4, 1, out mbest); // bese on example 6-4 of book
            for (int i = 0; i < mbest.Count; i++)
            {
                Console.WriteLine("\n" + (i + 1).ToString() + "-\tMax Probability : " + mbest.description[i].Probability);
                Console.Write("\tDecide : ");
                Print(mbest.description[i].D);
            }
            Console.WriteLine("\n-------------------------------------------------------------// ");
            Console.ReadKey();
        }
        static void Kna_Sort(int[] w, int[] p, int n)
        {
            float[] PbarW = new float[n + 1];
            for (int i = 1; i < PbarW.Length; i++)
                PbarW[i] = (float)p[i] / w[i];
            for (int i = 2; i < PbarW.Length; i++)
                for (int j = 1; j < PbarW.Length - i; j++)
                {
                    if (PbarW[j] < PbarW[j + 1])
                    {
                        float tmpF = PbarW[j];
                        PbarW[j] = PbarW[j + 1];
                        PbarW[j + 1] = tmpF;
                        int tmpI = p[j];
                        p[j] = p[j + 1];
                        p[j + 1] = tmpI;
                        tmpI = w[j];
                        w[j] = w[j + 1];
                        w[j + 1] = tmpI;
                    }
                }
        }
        static void Print(List<int> list)
        {
            if (list.Count > 0)
            {
                Console.Write("[");
                for (int i = 0; i < list.Count - 1; i++)
                {
                    Console.Write(list[i] + ",");
                }
                Console.Write(list[list.Count - 1] + "] ");
            }
            else
            {
                Console.Write("Null ");
            }
        }
    }
}
